const { Hotel } = require('../models');

/**
 * Get hotel public information
 */
const getHotelInfo = async (req, res) => {
    try {
        const { hotelId } = req.params;

        const hotel = await Hotel.findByPk(hotelId, {
            attributes: [
                'id', 'name', 'tagline', 'description',
                'address', 'phone', 'whatsappNumber',
                'logoUrl', 'bannerUrl', 'isActive', 'subscriptionEnd'
            ]
        });

        if (!hotel) {
            return res.status(404).json({
                success: false,
                message: 'Hotel not found'
            });
        }

        // Check if subscription is active
        const now = new Date();
        const subscriptionEnd = new Date(hotel.subscriptionEnd);
        const isSubscriptionActive = hotel.isActive && subscriptionEnd > now;

        res.json({
            success: true,
            data: {
                id: hotel.id,
                name: hotel.name,
                tagline: hotel.tagline,
                description: hotel.description,
                address: hotel.address,
                phone: hotel.phone,
                whatsapp: hotel.whatsappNumber,
                logo: hotel.logoUrl,
                banner: hotel.bannerUrl,
                isActive: isSubscriptionActive
            }
        });
    } catch (error) {
        console.error('Get hotel info error:', error);
        res.status(500).json({
            success: false,
            message: 'Server error'
        });
    }
};

module.exports = {
    getHotelInfo
};
