const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const Hotel = require('./Hotel');

const Category = sequelize.define('Category', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    hotelId: {
        type: DataTypes.STRING(36),
        allowNull: false,
        field: 'hotel_id',
        references: {
            model: Hotel,
            key: 'id'
        },
        onDelete: 'CASCADE'
    },
    name: {
        type: DataTypes.STRING(100),
        allowNull: false
    },
    mealTimes: {
        type: DataTypes.JSON,
        allowNull: false,
        field: 'meal_times',
        defaultValue: ['Lunch', 'Dinner']
    }
}, {
    tableName: 'categories',
    timestamps: true
});

// Define association
Category.belongsTo(Hotel, { foreignKey: 'hotelId', as: 'hotel' });
Hotel.hasMany(Category, { foreignKey: 'hotelId', as: 'categories' });

module.exports = Category;
