const path = require('path');
const { Hotel } = require(path.join(__dirname, '..', 'models'));
const { sequelize } = require(path.join(__dirname, '..', 'config', 'database'));
require('dotenv').config({ path: path.join(__dirname, '..', '.env') });

async function checkHotels() {
    try {
        await sequelize.authenticate();
        console.log('✅ Connected to database\n');

        const hotels = await Hotel.findAll({
            attributes: ['id', 'name', 'email', 'subscriptionEnd', 'isActive']
        });

        console.log('📊 Hotels in database:\n');
        console.log('='.repeat(80));

        if (hotels.length === 0) {
            console.log('❌ No hotels found! Run: npm run init-db');
        } else {
            hotels.forEach((hotel, index) => {
                console.log(`\n${index + 1}. Hotel: ${hotel.name}`);
                console.log(`   ID: ${hotel.id}`);
                console.log(`   Email: ${hotel.email}`);
                console.log(`   Active: ${hotel.isActive}`);
                console.log(`   Subscription End: ${hotel.subscriptionEnd}`);

                const now = new Date();
                const end = new Date(hotel.subscriptionEnd);
                const daysLeft = Math.ceil((end - now) / (1000 * 60 * 60 * 24));
                console.log(`   Days Remaining: ${daysLeft}`);
            });
        }

        console.log('\n' + '='.repeat(80));
        console.log('\n✅ Login Credentials:');
        console.log('   Email: demo@hotel.com');
        console.log('   Password: demo123');
        console.log('\n📝 Use the Hotel ID above in your public URL:');
        console.log(`   http://localhost:3000/?hotel=HOTEL_ID\n`);

        process.exit(0);
    } catch (error) {
        console.error('❌ Error:', error.message);
        process.exit(1);
    }
}

checkHotels();
