const path = require('path');
const { Hotel } = require(path.join(__dirname, '..', 'models'));
const { sequelize } = require(path.join(__dirname, '..', 'config', 'database'));
require('dotenv').config({ path: path.join(__dirname, '..', '.env') });

async function extendDemoSubscription() {
    try {
        await sequelize.authenticate();
        console.log('✅ Connected to database\n');

        // Find demo hotel
        const demoHotel = await Hotel.findOne({
            where: { email: 'demo@hotel.com' }
        });

        if (!demoHotel) {
            console.log('❌ Demo hotel not found!');
            console.log('   Run: npm run init-db');
            process.exit(1);
        }

        // Extend subscription by 1 year from now
        const newSubscriptionEnd = new Date();
        newSubscriptionEnd.setFullYear(newSubscriptionEnd.getFullYear() + 1);

        await demoHotel.update({
            subscriptionEnd: newSubscriptionEnd,
            isActive: true
        });

        console.log('✅ Demo hotel subscription extended!\n');
        console.log('Hotel Details:');
        console.log(`   Name: ${demoHotel.name}`);
        console.log(`   Email: ${demoHotel.email}`);
        console.log(`   Password: demo123`);
        console.log(`   Hotel ID: ${demoHotel.id}`);
        console.log(`   Subscription End: ${newSubscriptionEnd.toLocaleDateString()}`);
        console.log(`   Days Remaining: 365\n`);
        console.log('✅ You can now login at: http://localhost:3000/#/admin/login\n');

        process.exit(0);
    } catch (error) {
        console.error('❌ Error:', error.message);
        process.exit(1);
    }
}

extendDemoSubscription();
