const path = require('path');
require('dotenv').config({ path: path.join(__dirname, '..', '.env') });

// Simple HTTP request without axios
const http = require('http');

function testLogin() {
    const postData = JSON.stringify({
        email: 'demo@hotel.com',
        password: 'demo123'
    });

    const options = {
        hostname: 'localhost',
        port: 5000,
        path: '/api/auth/login',
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Content-Length': Buffer.byteLength(postData)
        }
    };

    console.log('🧪 Testing Hotel Admin Login\n');
    console.log('Sending request to: http://localhost:5000/api/auth/login');
    console.log('Credentials: demo@hotel.com / demo123\n');

    const req = http.request(options, (res) => {
        let data = '';

        res.on('data', (chunk) => {
            data += chunk;
        });

        res.on('end', () => {
            console.log(`Status Code: ${res.statusCode}\n`);

            try {
                const response = JSON.parse(data);
                console.log('Response:');
                console.log(JSON.stringify(response, null, 2));

                if (res.statusCode === 200) {
                    console.log('\n✅ LOGIN SUCCESSFUL!');
                    console.log('   You should be able to login in the browser.');
                } else if (res.statusCode === 403) {
                    console.log('\n❌ LOGIN FAILED - Subscription Issue');
                    if (response.subscriptionExpired) {
                        console.log('   The subscription is expired in the database.');
                        console.log('   Run: npm run extend-demo');
                    } else {
                        console.log('   Account might be suspended.');
                    }
                } else if (res.statusCode === 401) {
                    console.log('\n❌ LOGIN FAILED - Invalid Credentials');
                    console.log('   Email or password is incorrect.');
                } else {
                    console.log('\n❌ LOGIN FAILED');
                }
            } catch (e) {
                console.log('Raw response:', data);
            }

            process.exit(res.statusCode === 200 ? 0 : 1);
        });
    });

    req.on('error', (e) => {
        console.error(`❌ Request failed: ${e.message}`);
        console.log('\nMake sure the backend is running:');
        console.log('   cd Backend');
        console.log('   npm run dev');
        process.exit(1);
    });

    req.write(postData);
    req.end();
}

testLogin();
